/*  Prüft die Einträge der Tabelle "scheduling.resource_timeline" vom Typ "off.day" auf logische Inkonsistenzen.
    Diese Funktion wird üblicherweise als Unterfunktion der DB-Funktion "scheduling.resource_timeline__validate_block" gerufen.
*/
SELECT tsystem.function__drop_by_regex( 'resource_timeline__validate_block_off_day', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.resource_timeline__validate_block_off_day(
    _block scheduling.resource_timeline
) RETURNS jsonb AS $$
DECLARE
    _ksvba_id int := context_id FROM scheduling.resource WHERE id = _block.ti_resource_id and context = 'ksvba';
    _issues jsonb := '{ "has_issues": false, "issues":[] }';
BEGIN

    IF ( _block.ti_type <> 'off.day' ) THEN
      RAISE EXCEPTION 'invalid block type, id % is not of type off.day', _block.ti_id;
    END IF;

    IF ( _block.ti_usage <> 1 ) THEN

        _issues := jsonb_set( _issues, '{has_issues}', 'true' );
        _issues := jsonb_insert( _issues, '{ issues, 0 }', '"load not equal to 1"' );
    END IF;

    IF ( _block.ti_date_start::time <> '00:00:00'::time ) THEN

        _issues := jsonb_set( _issues, '{has_issues}', 'true' );
        _issues := jsonb_insert( _issues, '{ issues, 0 }', '"offday start time is wrong"' );
    END IF;

    IF ( _block.ti_date_end::time <> '00:00:00'::time ) THEN

        _issues := jsonb_set( _issues, '{has_issues}', 'true' );
        _issues := jsonb_insert( _issues, '{ issues, 0 }', '"offday end time is wrong"' );
    END IF;

    IF (
          extract( dow from _block.ti_date_start )
        = any( scheduling.ksvba__get_workingdays( _ksvba_id ) )
    ) THEN

    _issues := jsonb_set( _issues, '{has_issues}', 'true' );
    _issues := jsonb_insert( _issues, '{ issues, 0 }', '"should be a working day"' );


    END IF;

    RETURN _issues;

END $$ language plpgsql;
